% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsnchk.R
\name{gsnchk}
\alias{gsnchk}
\title{Merchuk's Method of calculating phase's composition in a Tieline applied to Murugesan Binodal Function}
\usage{
gsnchk(XYdt, Xm, Ym, Vt, Vb, dyt, dyb)
}
\arguments{
\item{XYdt}{- Standard bidimensional data.frame used in most of functions available in this package.}

\item{Xm}{- Component X's concentration in the tieline's global composition.}

\item{Ym}{- Component Y's concentration in the tieline's global composition.}

\item{Vt}{- Tieline's TOP phase volume.}

\item{Vb}{- Tieline's BOTTOM phase volume.}

\item{dyt}{- Tieline's TOP phase density}

\item{dyb}{- Tieline's BOTTOM phase density}
}
\value{
sysres - The function returns the Critical Point (X,Y), Tieline Length (TLL), Tieline's Equivolume point (xVRe2o,yVRe2o),
and Tieline's Slope.
}
\description{
Merchuk et al. described a very straightforward method to calculate the concentration of each
component in the tieline giving only its global composition and phase's properties (such as volume and density).
However, other researchers relate to have achieved better fitting results using Murugesan's functions.
This method offers Merchul's ways o calculate Tieline's composition but using the equation proposed by Murugesan.
}
\details{
Merchuk's Method of calculating phase's composition in a Tieline applied to Murugesan Binodal Function

Using the binodal data, the global composition of a chosen tieline and its phases properties (more precisely
each phase density and volume). Using the data included in LLSR package the function couldn't achieve steady-state and
consecutively have a poor convergence tolerance. Use for your own risk.
}
\examples{
#
XYdt <- peg4kslt[,1:2]
#
Xm <- peg4kslt[2,3]
Ym <- peg4kslt[2,4]
Vt <- peg4kslt[2,5]
Vb <- peg4kslt[2,6]
dyt <- peg4kslt[2,7]
dyb <- peg4kslt[2,8]
#
gsnchk(XYdt,Xm,Ym,Vt,Vb,dyt,dyb)
}

