% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{predict.LMMsolve}
\alias{predict.LMMsolve}
\title{Predict function}
\usage{
\method{predict}{LMMsolve}(
  object,
  newdata,
  type = c("response", "link"),
  se.fit = FALSE,
  deriv = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class LMMsolve.}

\item{newdata}{A data.frame containing new points for which the smooth
trend should be computed. Column names should include the names used when
fitting the spline model.}

\item{type}{When this has the value "link" the linear predictor fitted
values or predictions (possibly with associated standard errors) are returned.
When type = "response" (default) fitted values or predictions on the scale of
the response are returned (possibly with associated standard errors).}

\item{se.fit}{calculate standard errors, default \code{FALSE}.}

\item{deriv}{Character string of variable for which to calculate the first derivative; default \code{NULL}.}

\item{...}{other arguments. Not yet implemented.}
}
\value{
A data.frame with predictions for the smooth trend on the specified
grid. The standard errors are saved if `se.fit=TRUE`.
}
\description{
Predict function
}
\examples{
## simulate some data
f <- function(x) { 0.3 + 0.4*x + 0.2*sin(20*x) }
set.seed(12)
n <- 150
x <- seq(0, 1, length = n)
sigma2e <- 0.04
y <- f(x) + rnorm(n, sd = sqrt(sigma2e))
dat <- data.frame(x, y)

## fit the model
obj <- LMMsolve(fixed = y ~ 1,
         spline = ~spl1D(x, nseg = 50), data = dat)

## make predictions
newdat <- data.frame(x = seq(0, 1, length = 5))
pred <- predict(obj, newdata = newdat, se.fit = TRUE)
pred

## make predictions for derivative of x:
pred2 <- predict(obj, newdata = newdat, se.fit = TRUE, deriv = "x")
pred2
}
