% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmm.R
\name{mlmm}
\alias{mlmm}
\title{Fit Multiple Linear Mixed Model}
\usage{
mlmm(..., data, by, effects = NULL, robust = FALSE, df = TRUE, ci = TRUE)
}
\arguments{
\item{...}{arguments passed to \code{\link{lmm}}.}

\item{data}{[data.frame] dataset (in the long format) containing the observations.}

\item{by}{[character] variable used to split the dataset. On each split a seperate linear mixed model is fit.}

\item{effects}{[character] Linear combinations of coefficients relative to which Wald test should be computed.}

\item{robust}{[logical] Should robust standard errors (aka sandwich estimator) be output instead of the model-based standard errors. Argument passed to \code{anova.lmm}.}

\item{df}{[logical] Should the degree of freedom be computed using a Satterthwaite approximation?}

\item{ci}{[logical] Should a confidence interval be output for each hypothesis?}
}
\description{
Fit several linear mixed models, extract relevant coefficients, and combine them into a single table.
}
\examples{

#### univariate regression ####
if(require(lava)){
library(LMMstar)
library(lava)

set.seed(10)
d1 <- cbind(sim(lvm(Y~0.5*X1), 25), group = "A")
d2 <- cbind(sim(lvm(Y~0.1*X1), 100), group = "B")
d3 <- cbind(sim(lvm(Y~0.01*X1), 1000), group = "C")
d1$id <- 1:NROW(d1)
d2$id <- 1:NROW(d2)
d3$id <- 1:NROW(d3)

d <- rbind(d1,d2,d3)

e.mlmm <- mlmm(Y~X1, data = d, by = "group", effects = "X1=0")
summary(e.mlmm, method = "single-step")
summary(e.mlmm, method = "bonferroni")
summary(e.mlmm, method = "single-step2")
## summary(e.mlmm)
}

#### multivariate regression ####
set.seed(10)
dL <- sampleRem(250, n.times = 3, format = "long")

e.mlmm <- mlmm(Y~X1+X2+X6, repetition = ~visit|id, data = dL,
               by = "X4", structure = "CS")
summary(e.mlmm, method = "none")
confint(e.mlmm, method = "none")

e.mlmmX1 <- mlmm(Y~X1+X2+X6, repetition = ~visit|id, data = dL,
               by = "X4", effects = "X1=0", structure = "CS")
summary(e.mlmmX1)
summary(e.mlmmX1, method = "single-step")

}
