% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep.data}
\alias{prep.data}
\title{Preparing Data}
\usage{
prep.data(data, lags, timepoints)
}
\arguments{
\item{data}{a matrix with rows representing genes and columns representing
different timepoints}

\item{lags}{a vector of same length as the number of rows in the data column
indicating the best lags}

\item{timepoints}{a vector of time points used in the dataset}
}
\value{
a list of two matrices, one matrix with NA's for the lags for the dataset
and another matrix with the timepoints used for each row in the dataset
}
\description{
This function prepares the data to compute correlation by introducing NA's when lags are needed
}
\examples{
prep.data(array(rnorm(20), c(5, 4)), c(0, 0, 0, -1, 1),
          timepoints = c(0, 5, 15, 30))


}
\author{
Thevaa Chandereng, Anthony Gitter
}
