% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LSD.makemovie.R
\name{makemovie}
\alias{LSD.makemovie}
\alias{makemovie}
\title{Interpolate rows of a matrix to extend the number of cols}
\usage{
makemovie(input, timepoints = NULL, timestep = 1, motionline = NULL)
}
\arguments{
\item{input}{a matrix with numerical entries.}

\item{timepoints}{a integer vector containing the timepoints corresponding to the columns of 'input'.}

\item{timestep}{a non-negative integer specifying the number of timesteps between the existing timepoints (defaults to \code{1}, if not specified).}

\item{motionline}{a integer vector giving the timepoints of the resulting matrix (derived from timepoints and timesteps by default).}
}
\description{
Interpolate rows of a matrix to yield a smooth transitions.
}
\examples{
len = 10
x = sin(seq(0,2*pi,length=len*2))
fun = function(){n=sample(1:len,1);return(x[n:(n+len-1)])}
input = t(replicate(7,fun(),simplify=TRUE))
input = input + rnorm(length(input))/2
par(mfrow=c(1,2))
plotmatrix(input,main="original",cols=1:7,type="o")
mov = makemovie(input,timestep=0.2)
plotmatrix(mov,main="interpolated",cols=1:7,type="o")
}
\author{
Achim Tresch, Bjoern Schwalb
}
\seealso{
\code{\link{clusterplot}}, \code{\link{align}}, \code{\link{demotour}}
}
\keyword{matrix}

