% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.color.r
\name{daltonize}
\alias{LSD.daltonize}
\alias{daltonize}
\title{Dichromat vision simulation for colorpalettes}
\usage{
daltonize(colpal, cvd = "p", show = TRUE)
}
\arguments{
\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{show}{logical: if \code{TRUE} (by default), the resulting colorpalettes are depicted in an R plot.}
}
\value{
\code{daltonize} returns a list, where each entry is a vector containing R built-in colors in hexadecimal representation: \item{simulated}{vector of simulated colors} \item{enhanced}{vector of enhanced colors}
}
\description{
Dichromat vision simulation and enhancement according to \url{http://www.daltonize.org}.
}
\examples{
daltonize("heat",cvd = "d")
daltonize("colorblind",cvd = "p")
}
\author{
Bjoern Schwalb
}
\references{
\url{http://www.daltonize.org}
}
\seealso{
\code{\link{disco}}, \code{\link{colorpalette}}, \code{\link{demotour}}
}
\keyword{colorblind}
\keyword{daltonize,}

