% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.color.r
\name{distinctcolors}
\alias{LSD.distinctcolors}
\alias{distinctcolors}
\title{Find preferably distinct R built-in colors}
\usage{
distinctcolors(nrcol = 10, method = "RGB", bw = FALSE, show = TRUE,
  simulate = TRUE)
}
\arguments{
\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to the length of \code{10}, if not specified).}

\item{method}{character string implying the method for color selection to be used ("RGB" uses a grid in the RGB space (default), "Lab" uses a grid in the Lab space, "goldenratio" uses the golden ratio as spacing between colors in the HSV color space).}

\item{bw}{logical: if \code{TRUE} (\code{FALSE} by default), the colors "black" and "white" are removed from the resulting colorpalette.}

\item{show}{logical: if \code{TRUE} (by default), the resulting colorpalettes are depicted in an R plot.}

\item{simulate}{logical: if \code{TRUE} (by default), a converted colorpalettes are additionally depicted to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}
}
\value{
\code{distinctcolors} returns a vector containing R built-in colors in hexadecimal representation.
}
\description{
Find a vector of distinct R built-in colors for a pre-defined length ('nrcol').
}
\examples{
distinctcolors()
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{disco}}, \code{\link{colorpalette}}, \code{\link{demotour}}
}
\keyword{color}

