% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.heathist.r
\name{heathist}
\alias{LSD.heathist}
\alias{heathist}
\title{Color a histogram}
\usage{
heathist(x, breaks = 20, xlab = NULL, ylab = NULL, main = "heathist",
  colpal = "greys", rev = FALSE, simulate = FALSE, daltonize = FALSE,
  cvd = "p", alpha = NULL, nobox = FALSE, add.density = FALSE,
  col.density = "darkred", add.rug = TRUE, col.rug = "black",
  nrcol = 100, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{breaks}{a numeric value giving the breaks of the histogram.}

\item{xlab}{x label, standard graphics parameter.}

\item{ylab}{y label, standard graphics parameter.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}) (defaults to "heat", if not specified).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{nobox}{logical: if \code{TRUE} (\code{FALSE} by default), the box of the plot is omitted.}

\item{add.density}{if \code{TRUE} (\code{FALSE} by default), a density line is added to the histogram.}

\item{col.density}{a R build-in color for the density line (if \code{add.density = TRUE}).}

\item{add.rug}{if \code{TRUE} (\code{FALSE} by default), a rug (1-d plot of the data) is added below the histogram-bars.}

\item{col.rug}{a R build-in color for the rug (if \code{add.rug = TRUE}).}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to 100, if not specified).}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
A histogram with an additional color stripe based on a kernel density estimate.
}
\examples{
x = rnorm(1000,mean = sample(c(0,3),size = 1000,prob = c(0.4,0.6),replace = TRUE))
heathist(x,xlab="x",add.density=TRUE,col.rug="darkred")

heathist(x,xlab="x",colpal = "matlablike")
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{histogram}

