% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_ljung_test.R
\name{Box.Ljung.Test}
\alias{Box.Ljung.Test}
\title{Ljung-Box Test Plot}
\usage{
Box.Ljung.Test(z, lag = NULL, main = NULL)
}
\arguments{
\item{z}{(type: numeric) data vector}

\item{lag}{(type: numeric) the number of periods for the autocorrelation}

\item{main}{(type: character) a title for the returned plot}
}
\value{
A ggplot object.
}
\description{
Plots the p-values Ljung-Box test.
}
\details{
The Ljung-Box test is used to check if exists autocorrelation in a time
series. The statistic is
\deqn{q = n(n+2)\cdot\sum_{j=1}^h \hat{\rho}(j)^2/(n-j)} with \emph{n} the
number of observations and \eqn{\hat{\rho}(j)} the autocorrelation
coefficient in the sample when the lag is \emph{j}. \code{LSTS_lbtp}
computes \eqn{q} and returns the p-values graph with lag \emph{j}.
}
\examples{
Box.Ljung.Test(malleco, lag = 5)
}
\references{
For more information on theoretical foundations and estimation methods see
\insertRef{brockwell2002introduction}{LSTS}
\insertRef{ljung1978measure}{LSTS}
}
\seealso{
\code{\link{periodogram}}
}
