% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_Liabilities.R
\name{estimate_liability}
\alias{estimate_liability}
\title{Estimating the genetic or full liability for a variable number of
phenotypes}
\usage{
estimate_liability(
  .tbl = NULL,
  family_graphs = NULL,
  h2 = 0.5,
  pid = "pid",
  fid = "fid",
  role = "role",
  family_graphs_col = "fam_graph",
  out = c(1),
  tol = 0.01,
  method = "PA",
  useMixture = FALSE,
  genetic_corrmat = NULL,
  full_corrmat = NULL,
  phen_names = NULL
)
}
\arguments{
\item{.tbl}{A matrix, list or data frame that can be converted into a tibble.
Must have at least five columns that hold the family identifier, the personal
identifier, the role and the lower and upper thresholds for all phenotypes
of interest. Note that the role must be one of the following abbreviations
- \code{g} (Genetic component of full liability)
- \code{o} (Full liability)
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to \code{NULL}.}

\item{family_graphs}{A tibble with columns pid and family_graph_col.
See prepare_graph for construction of the graphs. The family graphs Defaults to NULL.}

\item{h2}{Either a number representing the heritability on liability scale for a
single phenotype, or a numeric vector representing the liability-scale heritabilities
for all phenotypes. All entries in h2 must be non-negative and at most 1.}

\item{pid}{A string holding the name of the column in \code{family} and
\code{threshs} that hold the personal identifier(s). Defaults to \code{"PID"}.}

\item{fid}{A string holding the name of the column in \code{family} that
holds the family identifier. Defaults to \code{"fid"}.}

\item{role}{A string holding the name of the column in \code{.tbl} that
holds the role.Each role must be chosen from the following list of abbreviations
- \code{g} (Genetic component of full liability)
- \code{o} (Full liability)
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to "role".}

\item{family_graphs_col}{Name of column with family graphs in family_graphs. Defaults to "fam_graph".}

\item{out}{A character or numeric vector indicating whether the genetic component
of the full liability, the full liability or both should be returned. If \code{out = c(1)} or
\code{out = c("genetic")}, the genetic liability is estimated and returned. If \code{out = c(2)} or
\code{out = c("full")}, the full liability is estimated and returned. If \code{out = c(1,2)} or
\code{out = c("genetic", "full")}, both components are estimated and returned.
Defaults to \code{c(1)}.}

\item{tol}{A number that is used as the convergence criterion for the Gibbs sampler.
Equals the standard error of the mean. That is, a tolerance of 0.2 means that the
standard error of the mean is below 0.2. Defaults to 0.01.}

\item{method}{Estimation method used to estimate the (genetic) liability. Defaults to "PA".
Current implementation of PA only supports estimates of genetic liability. For full or both
genetic and full liability estimates use "Gibbs".}

\item{useMixture}{Logical indicating whether the mixture model should be used to calculate the genetic liability.
Requires K_i and K_pop columns as well as lower and upper. Defaults to FALSE.}

\item{genetic_corrmat}{Either \code{NULL} (if \code{h2} is a number) or a numeric
matrix (if \code{h2} is a vector of length > 1) holding the genetic correlations
between the desired phenotypes. All diagonal entries must be equal to one, while
all off-diagonal entries must be between -1 and 1. In addition, the matrix must
be symmetric. Defaults to \code{NULL}.}

\item{full_corrmat}{Either \code{NULL} (if \code{h2} is a number) or a numeric
matrix (if \code{h2} is a vector of length > 1) holding the full correlations
between the desired phenotypes. All diagonal entries must be equal to one, while
all off-diagonal entries must be between -1 and 1. In addition, the matrix must
be symmetric. Defaults to \code{NULL}.}

\item{phen_names}{Either \code{NULL} or a character vector holding the phenotype
names. These names will be used to create the row and column names for the
covariance matrix. If it is not specified, the names will default to
phenotype1, phenotype2, etc. Defaults to NULL.}
}
\value{
If \code{family} and \code{threshs} are two matrices, lists or
data frames that can be converted into tibbles, if \code{family} has two
columns named like the strings represented in \code{pid} and \code{fid}, if
\code{threshs} has a column named like the string given in \code{pid} as
well as a column named "lower" and a column named "upper" and if the
liability-scale heritability \code{h2} is a number (\code{length(h2)=1}),
and \code{out}, \code{tol} and
\code{always_add} are of the required form, then the function returns a
tibble with either four or six columns (depending on the length of out).
The first two columns correspond to the columns \code{fid} and \code{pid} '
present in \code{family}.
If \code{out} is equal to \code{c(1)} or \code{c("genetic")}, the third
and fourth column hold the estimated genetic liability as well as the
corresponding standard error, respectively.
If \code{out} equals \code{c(2)} or \code{c("full")}, the third and
fourth column hold the estimated full liability as well as the
corresponding standard error, respectively.
If \code{out} is equal to \code{c(1,2)} or \code{c("genetic","full")},
the third and fourth column hold the estimated genetic liability as
well as the corresponding standard error, respectively, while the fifth and
sixth column hold the estimated full liability as well as the corresponding
standard error, respectively.
If \code{h2} is a numeric vector of length greater than 1 and if
\code{genetic_corrmat}, \code{full_corrmat}, \code{out} and \code{tol} are of the
required form, then the function returns a tibble with at least six columns (depending
on the length of out).
The first two columns correspond to the columns \code{fid} and \code{pid} present in
the tibble \code{family}.
If \code{out} is equal to \code{c(1)} or \code{c("genetic")}, the third and fourth columns
hold the estimated genetic liability as well as the corresponding standard error for the
first phenotype, respectively.
If \code{out} equals \code{c(2)} or \code{c("full")}, the third and fourth columns hold
the estimated full liability as well as the corresponding standard error for the first
phenotype, respectively.
If \code{out} is equal to \code{c(1,2)} or \code{c("genetic","full")}, the third and
fourth columns hold the estimated genetic liability as well as the corresponding standard
error for the first phenotype, respectively, while the fifth and sixth columns hold the
estimated full liability as well as the corresponding standard error for the first
phenotype, respectively.
The remaining columns hold the estimated genetic liabilities and/or the estimated full
liabilities as well as the corresponding standard errors for the remaining phenotypes.
}
\description{
\code{estimate_liability} estimates the genetic component of the full
liability and/or the full liability for a number of individuals based
on their family history for one or more phenotypes.  It is a wrapper around
\code{\link{estimate_liability_single}} and \code{\link{estimate_liability_multi}}.
}
\details{
This function can be used to estimate either the genetic component of the
full liability, the full liability or both for a variable number of traits.
}
\examples{
genetic_corrmat <- matrix(0.4, 3, 3)
diag(genetic_corrmat) <- 1
full_corrmat <- matrix(0.6, 3, 3)
diag(full_corrmat) <- 1
#
sims <- simulate_under_LTM(fam_vec = c("m","f"), n_fam = NULL, add_ind = TRUE,
genetic_corrmat = genetic_corrmat, full_corrmat = full_corrmat, h2 = rep(.5,3),
n_sim = 1, pop_prev = rep(.1,3))
estimate_liability(.tbl = sims$thresholds, h2 = rep(.5,3),
genetic_corrmat = genetic_corrmat, full_corrmat = full_corrmat,
pid = "indiv_ID", fid = "fid", role = "role", out = c(1),
phen_names = paste0("phenotype", 1:3), tol = 0.01)

}
\seealso{
\code{\link[future.apply]{future_apply}}, \code{\link{estimate_liability_single}},
\code{\link{estimate_liability_multi}}
}
