% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lucid.R
\name{plot_lucid}
\alias{plot_lucid}
\title{Plot Sankey diagram for integrative clustering}
\usage{
plot_lucid(x, switch = FALSE, colorScale = default)
}
\arguments{
\item{x}{An \code{IntClust} class object}

\item{switch}{An indicator to do label switching with a descending order in gamma or not, the default is FALSE}

\item{colorScale}{D3 color scheme for the Sankey diagram}
}
\description{
\code{plot_lucid} generates a Sankey diagram for the results of integrative clustering based on an \code{IntClust} object.
}
\examples{
# Run the model with covariates in the G->X path
IntClusCoFit1 <- est_lucid(G=G1,CoG=CoG,Z=Z1,Y=Y1,K=2,family="binary",Pred=TRUE)

# Visualize the results of integrative clustering
plot_lucid(IntClusCoFit1)
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
