% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_output.R
\name{get_output}
\alias{get_output}
\title{Transform input X to output Y}
\usage{
get_output(x, tau, return.z = FALSE)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{tau}{named vector \eqn{\tau} which defines the variable transformation.
Must have at least \code{'mu_x'} and \code{'sigma_x'} element; see
\code{\link{complete_tau}} for details.}

\item{return.z}{should the shifted and scaled output also be returned?
Default: \code{FALSE}.}
}
\value{
A numeric object of same size/dimension as input \code{x}.

If \code{return.z = TRUE}, then it returns a list with 2 vectors
\item{z}{shifted and scaled input \eqn{\boldsymbol z}, } 
\item{y}{transformed output data \eqn{\boldsymbol y}, which has a Lambert W
\eqn{\times} F distribution.}
}
\description{
\code{get_output} transforms the input \eqn{\boldsymbol x} to the observed
    data \eqn{\boldsymbol y} given the transformation vector \eqn{\tau =
    (\mu_x(\boldsymbol \beta), \sigma_x(\boldsymbol \beta), \gamma, \alpha,
    \delta)}.

This is the inverse of \code{\link{get_input}}.
}
\seealso{
\code{\link{get_input}}; \code{\link{Gaussianize}} with argument \code{inverse = TRUE}.
}
\keyword{manip}
