% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initTarget.details.R
\name{initTarget.details}
\alias{initTarget.details}
\title{To initialize target, hierarchical correlation algorithm.}
\usage{
initTarget.details(target, data)
}
\arguments{
\item{target}{is a numeric vector, a matrix or a data frame.}

\item{data}{is a data frame with the main data.}
}
\value{
A cluster. Explanation.
}
\description{
To initialize target, hierarchical correlation algorithm. It checks if target is valid, if not, it initializes the target
}
\details{
This function is part of the hierarchical correlation method. The function initializes \code{target} and checks if it is an acceptable target.

The function transforms the target into a matrix. Then, it checks if the target has only one row and the same columns have the main data.

If it is not an acceptable target, the function will notice the problem and will initialize a new target with every column with value 0.
}
\examples{

data <- matrix(c(1,2,1,4,5,1,8,2,9,6,3,5,8,5,4),ncol= 3)

dataFrame <- data.frame(data)

target1 <- matrix(c(2,3))

target2 <- matrix(c(2,3,6))

initTarget.details(target1,dataFrame)

initTarget.details(target2,dataFrame)

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
