% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showVmGlgExamples.R
\name{showVmGlgExamples}
\alias{showVmGlgExamples}
\title{Display insurance contract calculation example}
\usage{
showVmGlgExamples(contract, prf = 10, t = 10, t_prf = 12, file = "", ...)
}
\arguments{
\item{contract}{The insurance contract to calculate and show}

\item{prf}{Time of premium waiver (premium-free)}

\item{t}{Time for which to show all values (except premium-free values)}

\item{t_prf}{Time for which to show all values after the premium waiver}

\item{file}{If given, outputs all information to the file rather than the console}

\item{...}{Further parameters (currently unused)}
}
\description{
Display the values of the example calculation of the given insurance contract
as required by the Austrian regulation (LV-VMGLV, "LV
Versicherungsmathematische Grundlagen Verordnung").
}
\examples{
library(MortalityTables)
mortalityTables.load("Austria_Annuities_AVOe2005R")
# A trivial deferred annuity tariff with no costs:
tariff = InsuranceTarif$new(name="Test Annuity", type="annuity",
    mortalityTable = AVOe2005R.unisex, i=0.01)
contract = InsuranceContract$new(
    tariff,
    age = 35, YOB = 1981,
    policyPeriod = 30, premiumPeriod = 15, deferralPeriod = 15,
    sumInsured = 1000,
    contractClosing = as.Date("2016-10-01")
);
showVmGlgExamples(contract)

# Optionally output to a file rather than the console:
\dontrun{
showVmGlgExamples(contract, file = "annuity-example.txt")
}
}
