% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCorrAlpha.R
\name{makeCorrAlpha}
\alias{makeCorrAlpha}
\title{Correlation matrix from Cronbach's Alpha}
\usage{
makeCorrAlpha(items, alpha, variance = 0.5, precision = 0)
}
\arguments{
\item{items}{(positive, int) matrix dimensions:
number of rows & columns to generate}

\item{alpha}{(real) target Cronbach's Alpha
(usually positive, must be between about -0.3 and +1)}

\item{variance}{(positive, real) Default = 0.5.
User-provided standard deviation of values sampled from a
normally-distributed log transformation.}

\item{precision}{(positive, real) Default = 0.
User-defined value ranging from '0' to '3' to add some random variation
around the target \emph{Cronbach's Alpha}.
'0' gives an exact alpha (to two decimal places)}
}
\value{
a correlation matrix
}
\description{
\code{makeCorrAlpha()} generates a random correlation
matrix of given dimensions and predefined \emph{Cronbach's Alpha}.

Such a correlation matrix can be applied to the \code{makeItems()}
function to generate synthetic data with the predefined alpha.
}
\note{
Random values generated by \code{makeCorrAlpha()} are highly volatile.
\code{makeCorrAlpha()} may not generate a feasible (positive-definite)
correlation matrix, especially when
\itemize{
\item variance is high relative to
\itemize{
\item desired Alpha, and
\item desired correlation dimensions
}
}

\code{makeCorrAlpha()} will inform the user if the resulting correlation
matrix is positive definite, or not.

If the returned correlation matrix is not positive-definite,
a feasible solution may still be possible. The user is encouraged to
try again, possibly several times, to find one.
}
\examples{

# define parameters
items <- 4
alpha <- 0.85
variance <- 0.5

# apply function
set.seed(42)
cor_matrix <- makeCorrAlpha(items = items, alpha = alpha, variance = variance)

# test function output
print(cor_matrix)
alpha(cor_matrix)
eigenvalues(cor_matrix, 1)

# higher alpha, more items
cor_matrix2 <- makeCorrAlpha(items = 8, alpha = 0.95)

# test output
cor_matrix2 |> round(2)
alpha(cor_matrix2) |> round(3)
eigenvalues(cor_matrix2, 1) |> round(3)


# large random variation around alpha
set.seed(42)
cor_matrix3 <- makeCorrAlpha(items = 6, alpha = 0.85, precision = 2)

# test output
cor_matrix3 |> round(2)
alpha(cor_matrix3) |> round(3)
eigenvalues(cor_matrix3, 1) |> round(3)

}
