% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossTables.R
\name{crossTables}
\alias{crossTables}
\title{Cross the original MS1 peaklist with the annotation results}
\usage{
crossTables(MS1, results, ppm = 5, rttol = 5,
  adductsTable = LipidMS::adductsTable)
}
\arguments{
\item{MS1}{data frame cointaining all peaks from the full MS function. It
must have three columns: m.z, RT (in seconds) and int (intensity).}

\item{results}{data frame. Output of identification functions.}

\item{ppm}{mass tolerance in ppm.}

\item{rttol}{rt tolerance to match peaks in seconds.}

\item{adductsTable}{data frame with the adducts to employ.}
}
\value{
Data frame with 6 columns: m.z, RT, int, LipidMS_id, adduct and
confidence level for the annotation. When multiple IDs are proposed for the
same feature, they are sorted based on the annotation level.
}
\description{
Cross the original MS1 peaklist with the annotation results.
}
\examples{
\donttest{results <- idNEG(LipidMS::serum_neg_fullMS, LipidMS::serum_neg_Ce20,
LipidMS::serum_neg_Ce40)
crossTables(MS1 = LipidMS::serum_neg_fullMS, results = results$results,
ppm = 10, rttol = 5, adductsTable = LipidMS::adductsTable)}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
