% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{plotLocalControlLTD}
\alias{plotLocalControlLTD}
\title{Plots the local treatment difference as a function of radius for localControlNearestNeighbors.}
\usage{
plotLocalControlLTD(lcnnResults, nnConfidence, ylim,
  legendLocation = "bottomleft", ylab = "LTD",
  xlab = "Fraction of maximum radius", main = "")
}
\arguments{
\item{lcnnResults}{Return object from localControlNearestNeighbors.}

\item{nnConfidence}{Return object from localControlNearestNeighborsConfidence}

\item{ylim}{The y axis bounds. Defaults to c(0,1).}

\item{legendLocation}{The location to place the legend. Default "topleft".}

\item{ylab}{The y axis label. Defaults to "LTD".}

\item{xlab}{The x axis label. Defaults to "Fraction of maximum radius".}

\item{main}{The main plot title. Default is empty.}
}
\description{
Creates a plot where the y axis represents the local treatment difference, 
while the x axis represents the percentage of the maximum radius. If the confidence summary (nnConfidence)  
is provided, the 50\% and 95\% confidence estimates are also plotted.
}
\examples{
data(lindner)
# Specify clustering variables.
linVars <- c("stent", "height", "female", "diabetic", 
             "acutemi", "ejecfrac", "ves1proc")
             
# Call Local Control once.
linRes <- localControlNearestNeighbors(data = lindner,
                                       clusterVars = linVars,
                                       treatmentColName = "abcix",
                                       outcomeColName = "cardbill",
                                       treatmentCode = 1)

# Plot the local treatment differences from Local Control without
# confidence intervals.
plotLocalControlLTD(linRes, ylim =  c(-6000, 3600))

#If the confidence intervals are calculated:
#linConfidence = localControlNearestNeighborsConfidence(
#                                      data = lindner,
#                                      clusterVars = linVars,
#                                      treatmentColName = "abcix",
#                                      outcomeColName = "cardbill",
#                                      treatmentCode = 1, nBootstrap = 100)

# Plot the local treatment difference with confidence intervals. 
#plotLocalControlLTD(linRes, linConfidence)

}
