#' @name ageChd
#' @docType data
#' @title Age and Coronary Heart Disease data
#'
#' @format A \code{data.frame} with
#' \eqn{100} observations (rows)
#' and \eqn{3} variables (columns).
#'
#' @details Age and presence of coronary heart disease for
#' 100 subjects.
#' \cr \cr
#' Columns are:
#' \describe{
#'  \item{ID}{Identification code. \eqn{1} to \eqn{100}.}
#'  \item{age}{Age (years).}
#'  \item{chd}{Evidence of coronary heart disease?
#'             (\code{factor}):
#'   \describe{
#'    \item{0}{no}
#'    \item{1}{yes}}}
#' }
#' @keywords datasets
#'
#' @seealso
#' \code{\link{sig}}
#' \code{\link{OR}}
#'
#' @source
#' \href{ftp://ftp.wiley.com/public/sci_tech_med/logistic}{
#'       Wiley FTP}
#' @references
#' \bold{H&L 2nd ed.} Page 3, Table 1.1.
NULL
