% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_Filter.R
\name{create_Filter}
\alias{create_Filter}
\title{Function to create a filter.}
\usage{
create_Filter(name, description, reference.thickness, thickness = NULL,
  reflexion, transmission)
}
\arguments{
\item{name}{\link{character}: Name of the filter.}

\item{description}{\link{character}: Description of the filter.}

\item{reference.thickness}{\link{numeric}: Reference thickness of the filter.}

\item{thickness}{\link{numeric}: Thickness of the filter (by default thickness = reference.thickness).}

\item{reflexion}{\link{numeric}: Reflexion of the filter (1-P).}

\item{transmission}{\link{numeric}: Transmission of the filter (T).}
}
\value{
This function return a new filter.
}
\description{
This function create a new filter.
}
\examples{
#Data
wavelength <- seq(200,1000,10)

values <- dnorm(x = wavelength,mean = 400,sd = 50)*dnorm(x = wavelength,mean = 200,sd = 50)
values <- values/max(values)

name <- "example"
description <- "non realistic filter"
reference.thickness <- 1
reflexion <- 1
transmission <- matrix(data=c(wavelength,
                              values),
                       nrow = 81,
                       ncol = 2,
                       byrow = FALSE)

#Filter
filter <- create_Filter(name = name,
                        description = description,
                        reference.thickness = reference.thickness,
                        reflexion = reflexion,
                        transmission = transmission)

plot_Filter(filter)


}
\author{
David Strebler, University of Cologne (Germany).
}

