% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data.Curve-class.R,
%   R/RLum.Data.Image-class.R, R/RLum.Data.Spectrum-class.R,
%   R/RLum.Results-class.R
\name{names_RLum}
\alias{names_RLum}
\alias{names_RLum,list-method}
\alias{names_RLum,RLum.Analysis-method}
\alias{names_RLum,RLum.Data.Curve-method}
\alias{names_RLum,RLum.Data.Image-method}
\alias{names_RLum,RLum.Data.Spectrum-method}
\alias{names_RLum,RLum.Results-method}
\title{Name retrieval function for RLum-class objects}
\usage{
names_RLum(object)

\S4method{names_RLum}{list}(object)

\S4method{names_RLum}{RLum.Analysis}(object)

\S4method{names_RLum}{RLum.Data.Curve}(object)

\S4method{names_RLum}{RLum.Data.Image}(object)

\S4method{names_RLum}{RLum.Data.Spectrum}(object)

\S4method{names_RLum}{RLum.Results}(object)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}
}
\value{
A \link{character} vector.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the input object, the corresponding
function will be selected.
}
\section{Functions}{
\itemize{
\item \code{names_RLum(list)}: Returns a list of names of the \linkS4class{RLum} objects that had been passed to
it.

\item \code{names_RLum(RLum.Analysis)}: Returns the names of the \linkS4class{RLum.Data} objects stored in the object.

\item \code{names_RLum(RLum.Data.Curve)}: Returns the names info elements stored in the object.

\item \code{names_RLum(RLum.Data.Image)}: Returns the names of the info elements stored in the object.

\item \code{names_RLum(RLum.Data.Spectrum)}: Returns the names of the info elements stored in the object.

\item \code{names_RLum(RLum.Results)}: Returns the names of the \code{data} field stored in the object.

}}
\section{Function version}{
 0.1.0
}

\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. names_RLum(): Name retrieval function for RLum-class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
