% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MABOUST.R
\name{MABOUST}
\alias{MABOUST}
\title{Conduct the MABOUST Trial design.}
\usage{
MABOUST(
  Y,
  T1,
  X,
  ACTIVE,
  FUTILITY,
  nTreat,
  nCat,
  UT,
  DeltaVEC,
  gamma,
  PSPIKE,
  B
)
}
\arguments{
\item{Y}{Ordinal Outcome Vector, labeled 1,...,J}

\item{T1}{Treatment Indicator, labeled 1,...,K.}

\item{X}{Matrix of patient covariates.}

\item{ACTIVE}{Binary indicator of active treatments. This vector must be length K, and have a 1 for each entry corresponding to an active treatment and 0 otherwise.}

\item{FUTILITY}{Binary indicator of whether a futility decision will be allowed.}

\item{nTreat}{Number of treatments in consideration, i.e. K.}

\item{nCat}{Number of ordinal outcome categories, i.e. J.}

\item{UT}{Vector of numerical utility scores to give outcomes 1,...,J.}

\item{DeltaVEC}{Vector of \eqn{\Delta} values to test.}

\item{gamma}{Length 3 vector of cutoff parameters.}

\item{PSPIKE}{Prior probability of a pairwise null effect.}

\item{B}{Number of MCMC iterations to perform.}
}
\value{
The set of active treatments to continue, an optimal treatment, or a set of equally optimal treatments. Also reports posterior mean utilities and ordinal outcome probabilities as well as pairwise comparisons of utility similarity, when appropriate.
}
\description{
Performs posterior sampling for the MABOUST design and determines whether the trial should continue and what treatment(s) are optimal.
}
\examples{
##Clinical Parameters
nCat = 6
nTreat = 3
UT = c(0,10,20,80,90,100)
DeltaVEC  = c(5,10)
###Which treatments are active?
ACTIVE = c(1,0,1) ###Treatments 1, 3 are active
FUTILITY = 1 ###Futility look is allowed.
###Design parameters
gamma= c(.5, .05, .05)
PSPIKE = .9
set.seed(1)
##Generate Random Data
n=300
Y=sample(1:nCat,n,replace=TRUE)
T1 = sample(1:nTreat,n,replace=TRUE)
X=matrix(rnorm(n*2),ncol=2)
###Number of iterations
B=100
MABOUST(Y, T1, X, ACTIVE, FUTILITY, nTreat, nCat, UT, DeltaVEC, gamma, PSPIKE,B )
}
\references{
[1] Chapple and Clement (2020), MABOUST: A Multi-Armed Bayesian Ordinal Outcome Utility-Based Sequential Trial. Submitted.
}
