/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util;

import java.lang.reflect.Array;

public abstract class ObjectHashBase {
    public static final String STANDARD_HASH = "base";
    public static final String IDENTITY_COMP = "comp";
    public static final String IDENTITY_HASH = "ident";
    protected static final double DEFAULT_FILL = 0.3;
    protected static final int MINIMUM_SIZE = 31;
    protected final boolean m_identHash;
    protected final boolean m_identCompare;
    protected final double m_fillFraction;
    protected int m_entryCount;
    protected int m_entryLimit;
    protected int m_arraySize;
    protected int m_hitOffset;

    public ObjectHashBase(int n, double d, Class clazz, Object object) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("fill value out of range");
        }
        this.m_fillFraction = d;
        if (object == STANDARD_HASH) {
            this.m_identHash = false;
            this.m_identCompare = false;
        } else if (object == IDENTITY_COMP) {
            this.m_identHash = false;
            this.m_identCompare = true;
        } else if (object == IDENTITY_HASH) {
            this.m_identHash = true;
            this.m_identCompare = true;
        } else {
            throw new IllegalArgumentException("Unknown hash technique specifier");
        }
        this.m_arraySize = Math.max((int)((double)n / this.m_fillFraction), 31);
        this.m_arraySize += (this.m_arraySize + 1) % 2;
        this.m_entryLimit = (int)((double)this.m_arraySize * this.m_fillFraction);
        this.m_hitOffset = this.m_arraySize / 2;
        this.setKeyArray(Array.newInstance(clazz, this.m_arraySize));
    }

    public ObjectHashBase(ObjectHashBase objectHashBase) {
        this.m_fillFraction = objectHashBase.m_fillFraction;
        this.m_entryCount = objectHashBase.m_entryCount;
        this.m_entryLimit = objectHashBase.m_entryLimit;
        this.m_arraySize = objectHashBase.m_arraySize;
        this.m_hitOffset = objectHashBase.m_hitOffset;
        this.m_identHash = objectHashBase.m_identHash;
        this.m_identCompare = objectHashBase.m_identCompare;
        Class<?> clazz = objectHashBase.getKeyArray().getClass().getComponentType();
        Object object = Array.newInstance(clazz, this.m_arraySize);
        System.arraycopy(objectHashBase.getKeyArray(), 0, object, 0, this.m_arraySize);
        this.setKeyArray(object);
    }

    public final int size() {
        return this.m_entryCount;
    }

    protected abstract Object[] getKeyArray();

    protected abstract void setKeyArray(Object var1);

    protected abstract void reallocate(int var1);

    protected void growCapacity(int n) {
        int n2 = this.m_arraySize;
        int n3 = this.m_entryLimit;
        while (n3 < n) {
            n2 = n2 * 2 + 1;
            n3 = (int)((double)n2 * this.m_fillFraction);
        }
        this.m_arraySize = n2;
        this.m_entryLimit = n3;
        this.m_hitOffset = n2 / 2;
        this.reallocate(n2);
    }

    public final void ensureCapacity(int n) {
        if (n > this.m_entryLimit) {
            this.growCapacity(n);
        }
    }

    public void clear() {
        Object[] objectArray = this.getKeyArray();
        int n = 0;
        while (n < this.m_arraySize) {
            objectArray[n] = null;
            ++n;
        }
        this.m_entryCount = 0;
    }

    protected final int stepSlot(int n) {
        return (n + this.m_hitOffset) % this.m_arraySize;
    }

    protected final int freeSlot(int n) {
        Object[] objectArray = this.getKeyArray();
        while (objectArray[n] != null) {
            n = this.stepSlot(n);
        }
        return n;
    }

    protected final int standardSlot(Object object) {
        return ((this.m_identHash ? System.identityHashCode(object) : object.hashCode()) & Integer.MAX_VALUE) % this.m_arraySize;
    }

    /*
     * Unable to fully structure code
     */
    protected int standardFind(Object var1_1) {
        block4: {
            var2_2 = this.standardSlot(var1_1);
            var3_3 = this.getKeyArray();
            if (!this.m_identCompare) ** GOTO lbl13
            while (var3_3[var2_2] != null) {
                if (var3_3[var2_2] == var1_1) {
                    return var2_2;
                }
                var2_2 = this.stepSlot(var2_2);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (var3_3[var2_2].equals(var1_1)) {
                    return var2_2;
                }
                var2_2 = this.stepSlot(var2_2);
lbl13:
                // 2 sources

                ** while (var3_3[var2_2] != null)
            }
        }
        return -var2_2 - 1;
    }
}

