/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import com.sosnoski.util.array.IntArray;
import java.util.Iterator;
import uk.ac.rhul.cs.graph.BreadthFirstSearchIterator;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadthFirstSearch
extends GraphAlgorithm
implements Iterable<Integer> {
    protected int seedNode;
    protected int[] subgraph = null;

    public int getSeedNode() {
        return this.seedNode;
    }

    public void setSeedNode(int seedNode) {
        this.seedNode = seedNode;
    }

    public BreadthFirstSearch(Graph graph, int seedNode) {
        super(graph);
        this.seedNode = seedNode;
    }

    public BreadthFirstSearchIterator iterator() {
        return new BreadthFirstSearchIterator(this.graph, this.seedNode, this.subgraph);
    }

    public int[] toArray() {
        IntArray result = new IntArray();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            result.add(i);
        }
        return result.toArray();
    }

    public void restrictToSubgraph(int[] subgraph) {
        this.subgraph = subgraph;
    }

    public void restrictToSubgraph(Integer[] subgraph) {
        this.subgraph = new int[subgraph.length];
        for (int i = 0; i < this.subgraph.length; ++i) {
            this.subgraph[i] = subgraph[i];
        }
    }
}

