% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateBurdenPlot.R
\name{generateBurdenPlot}
\alias{generateBurdenPlot}
\title{Function to generate Burden plot}
\usage{
generateBurdenPlot(
  mymaf,
  plotType = NULL,
  mb_covered = NULL,
  save_data_to_file = NULL
)
}
\arguments{
\item{mymaf}{The MAF object}

\item{plotType}{Type of plot (Either "Dotplot" or "Barplot")}

\item{mb_covered}{Total covered bases for mutation count
normalization}

\item{save_data_to_file}{The name and path of the output file}
}
\value{
A ggplot object containing the burden plot
}
\description{
This function generates burden plot
using the MAF data.
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
generateBurdenPlot(read.maf(maf), plotType="Dotplot")
generateBurdenPlot(read.maf(maf), plotType="Barplot")

}
\author{
Mayank Tondon, Ashish Jain
}
