% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Desc_function.R
\name{MAGMA_desc}
\alias{MAGMA_desc}
\title{MAGMA_desc}
\usage{
MAGMA_desc(
  Data,
  covariates,
  group,
  step_num = NULL,
  step_var = NULL,
  filename = NULL,
  verbose = TRUE,
  covariates_ordinal = NULL,
  covariates_nominal = NULL
)
}
\arguments{
\item{Data}{A data frame that contains the desired variable for density
plotting as well as the specified grouping variable.}

\item{covariates}{A character vector specifying the variable names of the
continuous variables for which the descriptive statistics should be computed.}

\item{group}{A character (vector) specifying the groups for which
differentiated statistics should be computed.}

\item{step_num}{An integer specifying the number of cases to be
included per group in this post matching comparison (e.g., 100). If no value
is specified, pre-matching statistics are computed. Is based on the step
variable of MAGMA. Optional argument.}

\item{step_var}{A character specifying the name of the step
variable in the data set. If no value is specified, pre matching
statistics are computed. Optional argument.}

\item{filename}{A character specifying the filename that
the resulting Word document with the Table should have. Optional argument.}

\item{verbose}{TRUE or FALSE indicating whether matching information should
be printed to the console.}

\item{covariates_ordinal}{A character vector specifying the variable names
of the ordinal variables for which the descriptive statistics should be
computed.}

\item{covariates_nominal}{A character vector specifying the variable names
of the nominal variables for which the descriptive statistics should be
computed.}
}
\value{
A table of descriptive statistics and pairwise effects for pre- or
post-matching samples.
}
\description{
This function provides pre- and post-matching descriptive statistics and
effects.
}
\details{
This function enables the computation of descriptive statistics of
continuous variables for the overall sample and specified groups. Additional,
pairwise effects (Cohen's d) are computed.
}
\examples{
# Defining covariates
covariates_gifted <- c("GPA_school", "IQ_score", "Motivation", "parents_academic")

# Estimating pre-matching descriptive statistics and pairwise effects using
# the data set 'MAGMA_sim_data'
# Estimating statistics for grouping variable 'gifted support' (received
# giftedness support yes or no)
MAGMA_desc(Data = MAGMA_sim_data,
           covariates = covariates_gifted,
           covariates_ordinal = "teacher_ability_rating",
           covariates_nominal = "gender",
           group =  "gifted_support")


# Estimating post-matching descriptive statistics and pairwise effects using
# the data set 'MAGMA_sim_data'
# Estimating statistics for grouping variable 'gifted support' (received
# giftedness support yes or no)
# Estimating statistics for 100 cases per group
MAGMA_desc(Data = MAGMA_sim_data,
           covariates = covariates_gifted,
           covariates_ordinal = "teacher_ability_rating",
           covariates_nominal = "gender",
           group =  "gifted_support",
           step_num = 100,
           step_var = "step_gifted")

}
\author{
Julian Urban
}
