% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSpectra.R
\name{loadSpectra}
\alias{loadSpectra}
\title{load bruker MALDI target plate spectra}
\usage{
loadSpectra(Dir, filter = NA, nameSpectra = TRUE, verbose = TRUE)
}
\arguments{
\item{Dir}{Character, parent directory of spectra.}

\item{filter}{Character vector, filter out spectra which match the given vector.}

\item{nameSpectra}{Logical, if TRUE the spectra in the resulting list will be named according to the dirname.}

\item{verbose}{Logical, print logs to the console.}
}
\value{
List of MALDIquant::MassSpectra
}
\description{
load bruker MALDI target plate spectra
}
\examples{
dataDir <- system.file("extdata", package="MALDIcellassay")
unzip(file.path(dataDir, "example-raw-spectra.zip"))

loadSpectra("example-raw-spectra/")

unlink("example-raw-spectra/", recursive = TRUE)
}
