context("filterPeaks")

p <- createMassPeaks(mass=1:5, intensity=1:5)
l <- list(p, p[1:4], p[1:3], p[1:2])

test_that("filterPeaks throws errors", {
  expect_error(filterPeaks(p), "no list of MALDIquant::MassPeaks")
  expect_error(filterPeaks(list()), "no list of MALDIquant::MassPeaks")
})

test_that("filterPeaks shows warnings", {
  expect_warning(filterPeaks(l, minFrequency=2),
                 " > 1 does not make sense! Using 1 instead")
  expect_warning(filterPeaks(l, minFrequency=-1),
                 " < 0 does not make sense! Using 0 instead")
})

test_that("filterPeaks", {
  expect_identical(filterPeaks(l, minFrequency=1),
                   list(p[1:2], p[1:2], p[1:2], p[1:2]))

  expect_identical(filterPeaks(l, minFrequency=0.5),
                   list(p[1:4], p[1:4], p[1:3], p[1:2]))

  expect_identical(filterPeaks(l, minFrequency=0), l)

  expect_identical(filterPeaks(l, minFrequency=1,
                               labels=factor(rep(letters[1:2], each=2),
                                             levels=letters[1:2])),
                   list(p[1:4], p[1:4], p[1:2], p[1:2]))

  ## test unused levels
  expect_identical(filterPeaks(l, minFrequency=1,
                               labels=factor(rep(letters[1:2], each=2),
                                             levels=letters[1:5])),
                   list(p[1:4], p[1:4], p[1:2], p[1:2]))

  ## test numbers
  expect_identical(filterPeaks(l, minFrequency=1,
                               labels=rep(1:2, each=2)),
                   list(p[1:4], p[1:4], p[1:2], p[1:2]))
})

