% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAPITR.R
\name{MAPITR}
\alias{MAPITR}
\title{MArginal ePIstasis Test for Regions
(\code{MAPITR})}
\usage{
MAPITR(
  Genotypes,
  Phenotype,
  Pathways,
  Covariates = NULL,
  CenterStandardize = TRUE,
  cores = NULL,
  ...
)
}
\arguments{
\item{Genotypes}{A n x p matrix containing the genotypes (0/1/2) for
all p SNPs across all n individuals. No default value.}

\item{Phenotype}{A vector containing phenotypic values for all
individuals being analyzed. No default value.}

\item{Pathways}{A r x 2 matrix containing the pathway names and then
a comma-separated list of the \code{Genotypes} column indices
representing each SNP in the associated pathway. Note, this second 
column of comma-separated indices are the numeric positions for each 
SNP in \code{Genotypes} and not the SNP IDs or column names. No
default value.}

\item{Covariates}{A n x q matrix containing any q additional covariates
that should be included in the M-projection matrix of the model. 
See Turchin et al. 2020 for details. Note that these are covariates
which are applied to both sides of the model, ie the phenotype as well
as the genotypes. A y-intercept term is automatically included and does
not need to be part of this n x q matrix. No default value.}

\item{CenterStandardize}{A logical \code{TRUE}/\code{FALSE} flag that
indicates whether the genotype matrix \code{Genotypes} should be
centered and standardized before analysis. This is a recommended step.
Indicate \code{FALSE} if this is a preprocessing step that has
already been done prior to running \code{MAPITR}. The default value 
is TRUE.}

\item{cores}{A numeric value providing the expected number of cores
if the OpenMP version of the code is being used. 
'parallel::detectCores()' is used by default to assign this variable 
when no value is given. A value generally should only be given when 
needing finer control of the code or for testing purposes. The 
default value is NULL.}

\item{...}{Additional optional arguments.}
}
\value{
A matrix containing in the first column the list of pathways
that were analyzed, in the second column the associated 
\code{MAPITR} p-values for each pathway, and in the third column the
associated \code{MAPITR} PVEs for each pathway.
}
\description{
Run \code{MAPITR} for a group of pathways on a single
phenotype and a set of genome-wide SNPs
}
\examples{
data(MAPITR_TestData_Genotypes, MAPITR_TestData_Phenotype, 
MAPITR_TestData_Pathways)
MAPITROutput <- MAPITR(MAPITR_TestData_Genotypes, MAPITR_TestData_Phenotype, 
MAPITR_TestData_Pathways)
MAPITROutput$Results

}
