% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_06_DE_2_0_PlotDEValues.R
\name{PlotDEValues}
\alias{PlotDEValues}
\title{Plot Differential Analysis Results}
\usage{
PlotDEValues(
  MarvelObject,
  de.p.val.adj,
  level,
  de.mean.diff = NULL,
  log2fc = NULL,
  anno = FALSE,
  anno.x.pos = NULL,
  anno.y.pos = NULL,
  anno.x.neg = NULL,
  anno.y.neg = NULL,
  n.top = NULL,
  label.size = 2.5
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{de.p.val.adj}{Numeric value. Adjusted p-value below which the splcing events or genes are considered as statistically significant and will consequently be color-annotated on the plot.}

\item{level}{Character string. Indicate \code{"splicing.distance"} if the percent spliced-in (PSI) values' distribution was previously tested between 2 groups of cells using the \code{CompareValues} function. Statistical tests for distribution include Kolmogorov-Smirnov, Kuiper, and Anderson-Darling test. Indicate \code{"splicing.mean"} or \code{gene} if the PSI or gene expression values' mean was previously tested between 2 groups of cells using the \code{CompareValues} function. Statistical tests for comparing mean are t-test and Wilcoxon rank-sum test.}

\item{de.mean.diff}{Numeric value. Only applicable when \code{level} set to \code{"splicing.mean"}. The positive (and negative) value specified above (and below) which the splicing events are considered to be statistically significant and will consequently be color-annotated on the plot.}

\item{log2fc}{Numeric value. Only applicable when \code{level} set to \code{"gene"}. The positive (and negative) value specified above (and below) which the genes are considered to be statistically significant and will consequently be color-annotated on the plot.}

\item{anno}{Logical value. If set to \code{TRUE}, the specific gene names will be annotated on the plot. Speficified together with \code{anno.x.pos}, \code{anno.y.pos}, \code{anno.x.neg}, and \code{anno.y.neg}.}

\item{anno.x.pos}{Numeric value. Only applicable if \code{anno} set to TRUE and when \code{level} set to \code{"splicing.mean"} or \code{gene}. The value above on the x-axis which the gene names will be annotated on the plot. Specified together with \code{anno.y.pos}, \code{anno.x.neg}, and \code{anno.y.neg}.}

\item{anno.y.pos}{Numeric value. Only applicable if \code{anno} set to TRUE and when \code{level} set to \code{"splicing.mean"} or \code{gene}. The value above on the y-axis which the gene names will be annotated on the plot. Specified together with \code{anno.x.pos}, \code{anno.x.neg}, and \code{anno.y.neg}.}

\item{anno.x.neg}{Numeric value. Only applicable if \code{anno} set to TRUE and when \code{level} set to \code{"splicing.mean"} or \code{gene}. The value below on the x-axis which the gene names will be annotated on the plot. Specified together with \code{anno.x.pos}, \code{anno.y.pos}, and \code{anno.y.neg}.}

\item{anno.y.neg}{Numeric value. Only applicable if \code{anno} set to TRUE and when \code{level} set to \code{"splicing.mean"} or \code{gene}. The value above on the y-axis which the gene names will be annotated on the plot. Specified together with \code{anno.y.pos}, \code{anno.x.neg}, and \code{anno.x.pos}.}

\item{n.top}{Numeric value. Only applicable if \code{anno} set to TRUE and when \code{level} set to \code{"splicing.distance"}. Top n differentially expressed splicing events are annotated on the plot.}

\item{label.size}{Numeric value. Only applicable if \code{anno} set to TRUE. Size of the gene name labels.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$DE$PSI$Plot} or \code{MarvelObject$DE$Exp$Plot} for splicing or gene data, respectively.
}
\description{
\code{PlotDEValues} plots the differential splicing or gene expression analysis results.
}
\details{
This function plot the differential splicing or gene expression analysis results and can annotate the user-defined significant data points and gene names.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- PlotDEValues(MarvelObject=marvel,
                       de.p.val.adj=0.10,
                       de.mean.diff=0.01,
                       level="splicing.mean",
                       anno=FALSE
                       )

# Check output
marvel$DE$PSI$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
