% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_06_DE_2_2_PlotDEValues_PSI_Distance.R
\name{PlotDEValues.PSI.Distance}
\alias{PlotDEValues.PSI.Distance}
\title{Plot Differential Splicing Analysis Results}
\usage{
PlotDEValues.PSI.Distance(
  MarvelObject,
  de.p.val.adj,
  anno = FALSE,
  n.top = NULL,
  label.size = 2.5
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{de.p.val.adj}{Numeric value. Adjusted p-value below which the splcing events are considered as statistically significant and will consequently be color-annotated on the plot.}

\item{anno}{Logical value. If set to \code{TRUE}, the specific gene names will be annotated on the plot. Speficified together with \code{n.top}.}

\item{n.top}{Numeric value. Only applicable when \code{anno} set to \code{TRUE}. Top n differentially expressed splicing events are annotated on the plot.}

\item{label.size}{Numeric value. Only applicable if \code{anno} set to TRUE. Size of the gene name labels.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$DE$PSI}.
}
\description{
\code{PlotDEValues.PSI.Distance} plots the differential splicing analysis results.
}
\details{
This function plot the differential splicing analysis results and can annotate the user-defined significant data points and gene names. Typically used when the distribution of percent spliced-in (PSI) values of 2 groups of cells were previously tested using Kolmogorov-Smirnov, Kuiper or Anderson-Darling test.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- PlotDEValues.PSI.Distance(MarvelObject=marvel,
                                    de.p.val.adj=0.10,
                                    anno=FALSE
                                    )

# Check output
marvel$DE$PSI$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
