% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_09_PREDICT_NMD_5_2_FindPTC_A3SS_NegStrand.R
\name{FindPTC.A3SS.NegStrand}
\alias{FindPTC.A3SS.NegStrand}
\title{Find premature terminal codon (PTC) for alternative 3' splice site (A3SS) located on the negative strand of the transcript}
\usage{
FindPTC.A3SS.NegStrand(MarvelObject, tran_id, gene_id)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues.PSI} and \code{ParseGTF} function.}

\item{tran_id}{Character string. Vector of \code{tran_id} to look for PTCs.}

\item{gene_id}{Character string. Vector of \code{gene_id} corresponding to the \code{tran_id} argument.}
}
\value{
A data frame of transcripts containing splicing events meeting the \code{psi.de.sig} and \code{psi.de.diff} criteria are categorised based on the presence or absence of PTCs.
}
\description{
Finds PTC(s) introduced by alternative exons into protein-coding transcripts.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

# Define relevant event type
results <- marvel.demo$DE$PSI$Table[["ad"]]
index.1 <- which(results$event_type=="A3SS")
index.2 <- grep(":-@", results$tran_id, fixed=TRUE)
index <- intersect(index.1, index.2)
results <- results[index, ]
tran_id <- results$tran_id[3]
gene_id <- results$gene_id[3]

# Find PTC
results <- FindPTC.A3SS.NegStrand(MarvelObject=marvel.demo,
                                  tran_id=NULL,
                                  gene_id=gene_id
                                  )

# Check output
head(results)
}
