% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_09_PREDICT_NMD_2_1_FindPTC_SE_PosStrand.R
\name{FindPTC.SE.PosStrand}
\alias{FindPTC.SE.PosStrand}
\title{Find premature terminal codon (PTC) for skipped-exon (SE) located on the positive strand of the transcript}
\usage{
FindPTC.SE.PosStrand(MarvelObject, tran_id, gene_id)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues.PSI} and \code{ParseGTF} function.}

\item{tran_id}{Character string. Vector of \code{tran_id} to look for PTCs.}

\item{gene_id}{Character string. Vector of \code{gene_id} corresponding to the \code{tran_id} argument.}
}
\value{
A data frame of transcripts containing splicing events meeting the \code{psi.de.sig} and \code{psi.de.diff} criteria are categorised based on the presence or absence of PTCs.
}
\description{
Finds PTC(s) introduced by alternative exons into protein-coding transcripts.
}
\details{
This function finds PTC(s) introduced by alternative exons into protein-coding transcripts. It also records the distance between a PTCs and the final splice junction for a given protein-coding transcript. Non-protein-coding transcripts or transcripts in which splicing events are located outside of the transcripts' open-reading frame (ORF) are not analysed for PTCs but are noted.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

# Define relevant event type
results <- marvel.demo$DE$PSI$Table[["ad"]]
index.1 <- which(results$event_type=="SE")
index.2 <- grep(":+@", results$tran_id, fixed=TRUE)
index <- intersect(index.1, index.2)
results <- results[index, ]
tran_id <- results$tran_id[1]
gene_id <- results$gene_id[1]

# Find PTC
results <- FindPTC.SE.PosStrand(MarvelObject=marvel.demo,
                                tran_id=NULL,
                                gene_id=gene_id
                                )

# Check output
head(results)
}
