% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_06_MODALITY_ANALYSIS_2_1_PropModality_Doughnut.R
\name{PropModality.Doughnut}
\alias{PropModality.Doughnut}
\title{Overall modality proportion}
\usage{
PropModality.Doughnut(MarvelObject, modality.column, modality.type, event.type)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{AssignModality} function.}

\item{modality.column}{Character string. Can take the value \code{"modality"}, \code{"modality.var"} or \code{"modality.bimodal.adj"}. Please refer to \code{AssignModality} function help page for more details.}

\item{modality.type}{Character string. \code{basic} indicates that only the main modalities (included, excluded, bimodal, middle, multimodal) are analysed. Sub-modalities (primary and dispersed) will be merged. \code{complete} indicates that both main and sub-modalities are analysed. Sub-modalities will not be merged.}

\item{event.type}{Character string. To indicate which event type to analyse. Can take the value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"} or \code{"A3SS"}. Specify \code{"all"} to include all event types.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$Modality$Prop$DoughnutChart$Table} and \code{MarvelObject$Modality$Prop$DoughnutChart$Plot}.
}
\description{
Tabulates and plots the proportion of each modality without breaking down by splicing event type.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- PropModality.Doughnut(MarvelObject=marvel.demo,
                                     modality.column="modality.bimodal.adj",
                                     modality.type="extended",
                                     event.type=c("SE", "MXE", "RI", "A5SS", "A3SS", "AFE", "ALE")
                                     )

# Check outputs
marvel.demo$Modality$Prop$DoughnutChart$Table
marvel.demo$Modality$Prop$DoughnutChart$Plot
}
