% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_09_PREDICT_NMD_6_PropPTC.R
\name{PropPTC}
\alias{PropPTC}
\title{Tabulate proportion of transcripts with PTC}
\usage{
PropPTC(MarvelObject, xlabels.size = 8, show.NovelSJ.NoCDS = TRUE, prop.test)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{FindPTC} function.}

\item{xlabels.size}{Numeric value. Size of the x-axis tick labels. Default is 8.}

\item{show.NovelSJ.NoCDS}{Logical value. If set to \code{TRUE} transcripts not analysed for premature terminal codon (PTC), e.g. non-protein-coding transcripts are tabulated and plotted.}

\item{prop.test}{Character string. \code{chisq} Chi-squared test used to compare the proportion of transcripts with PTC across the different event splicing type. \code{fisher} Fisher test used to compare the proportion of transcripts with PTC across the different splicing event type.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$NMD$PTC.Prop$Table}, \code{MarvelObject$NMD$PTC.Prop$Plot}, and \code{MarvelObject$NMD$PTC.Prop$Plot.Stats}.
}
\description{
Tabulates and plots the proportion of transcripts with PTC for each splicing event type.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- PropPTC(MarvelObject=marvel.demo,
                       xlabels.size=8,
                       show.NovelSJ.NoCDS=TRUE,
                       prop.test="fisher"
                       )

# Check outputs
head(marvel.demo$NMD$PTC.Prop$Table)
marvel.demo$NMD$PTC.Prop$Plot
marvel.demo$NMD$PTC.Prop$Plot.Stats
}
