% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_02_PREPROCESS_1_AnnotateGenes.R
\name{AnnotateGenes.10x}
\alias{AnnotateGenes.10x}
\title{Annotate splice junctions}
\usage{
AnnotateGenes.10x(MarvelObject)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject.10x} function.}
}
\value{
An object of class S3 containing the updated slots \code{MarvelObject$gene.metadata} and \code{gene.norm.matrix}.
}
\description{
Annotates the each gene in the gene metadata with the gene type, e.g. protein-coding, antisense etc.. Annotations are retrieved from GTF. Only genes found in gene metadata and GTF will be retained.
}
\examples{

# Load un-processed MARVEL object
marvel.demo.10x.raw <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.raw.rds",
                               package="MARVEL")
                               )

# Annotate gene metadata
marvel.demo.10x <- AnnotateGenes.10x(MarvelObject=marvel.demo.10x.raw)
}
