% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_04_PREPROCESS_3_0_CheckAlignment.R
\name{CheckAlignment}
\alias{CheckAlignment}
\title{Pre-flight check}
\usage{
CheckAlignment(MarvelObject, level)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{level}{Character string. Indicate \code{"SJ"}, \code{"splicing"} or \code{"gene"} for splice junction, splicing or gene data, respectively. \code{"SJ"} typically specified before computing PSI values. \code{"splicing"} or \code{"gene"} typically specified after computing PSI values.}
}
\value{
An object of class S3 with updated slots \code{MarvelObject$SpliceJunction}, \code{MarvelObject$IntronCoverage}, \code{MarvelObject$SplicePheno}, \code{MarvelObject$SpliceFeatureValidated}, and \code{MarvelObject$PSI} or \code{MarvelObject$GenePheno}, \code{MarvelObject$GeneFeature}, and \code{MarvelObject$Gene} are updated for splicing or gene data, respectively.
}
\description{
Checks if the metadata aligns with the columns and rows of the matrix for splicing or gene data. This is a wrapper function for \code{CheckAlignment.PSI}, \code{CheckAlignment.Exp}, \code{CheckAlignment.PSI.Exp}, and \code{CheckAlignment.SJ}.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- CheckAlignment(MarvelObject=marvel.demo,
                              level="SJ"
                              )
}
