% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{mb.make.contrast}
\alias{mb.make.contrast}
\title{Convert arm-based MBNMA data to contrast data}
\usage{
mb.make.contrast(network, datatype = NULL, format = "wide")
}
\arguments{
\item{network}{An object of class \code{mb.network}}

\item{datatype}{A string indicating the data type. Can be \code{binomial} or \code{normal}}

\item{format}{A string indicating the data format. Can be \code{wide} (two additional columns for each
variable - contrast arms) or \code{long}.}
}
\value{
A data frame with the following columns. In \code{wide} format, some columns are given the indices
1 and 2 to indicate each arm in a given treatment comparison.:
\itemize{
\item \code{t} The treatment in each arm
\item \code{TE} The treatment effect (mean difference, log-odds) for the treatment in arm 1 versus the treatment
in arm 2
\item \code{seTE} The standard error for the treatment effect (mean difference, log-odds) for the treatment in
arm 1 versus the treatment in arm 2
\item \code{y} The mean response in each arm
\item \code{se} The standard error of the mean in each arm
\item \code{r} The number of responders in each arm
\item \code{n} The total number of participants in each arm
\item \code{fupcount} Follow-up identifier
\item \code{time} The time the data are reported
\item \code{studyID} Study identifier
}
}
\description{
Converts an object of class \code{mb.network} from arm-based long MBNMA data to a data frame with
contrast data (a separate contrast for each treatment comparison at each time point within each
study). Data can be either long or wide.
}
\examples{
# Create mb.network
network <- mb.network(osteopain)

# Convert to wide contrast data
mb.make.contrast(network, format="wide")

# Convert to long contrast data
mb.make.contrast(network, format="long")
}
