% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Theadways.R
\name{Theadways}
\alias{Theadways}
\title{To get headways and train arrive times for a given station/route/direction in
a certain time window.. Returns a list of headways at an origin station
during a particular time period on a particular route.}
\usage{
Theadways(from_stop_id, to_stop_id = NULL, route_id = NULL,
  direction_id = NULL, from_datetime = (Sys.time() - 1800),
  to_datetime = Sys.time(), api_key)
}
\arguments{
\item{from_stop_id}{GTFS-compatible stop_id for the origin stop for which
headways should be returned.}

\item{to_stop_id}{GTFS-compatible stop_id for the destination stop for which
headways should be returned. If empty will use departures from origin stop
with any destination stop on that route (i.e. not distinguishing between
branches).}

\item{route_id}{GTFS-compatible route_id value for which headways should be
returned. If this is not included, headways for all routes between the from
and to stop will be provided.}

\item{direction_id}{Direction of travel for headways to be returned. If
empty, will rely on}

\item{from_datetime}{The start of the time period that the headways (arrival
time at the origin stop) should fall within; converts to epoch time.}

\item{to_datetime}{The end of the time period that the headways (arrival time
at the origin stop) should fall within; converts to epoch time.}

\item{api_key}{API key for MBTA Performance API. To obtain one, visit the
MBTA Developer Portal (\url{https://mbta.com/developers/mbta-performance/})}
}
\value{
Arrival times for vehicles at the particular origin stop during the
  time window requested. \item{route_id}{GTFS-compatible route identifier for
  which headways are returned.} \item{direction}{Direction id (0/1) for which
  headways are returned.} \item{current_dep_dt}{Next departure time from
  origin stop during the time window specified.}
  \item{previous_dep_dt}{Previous departure time at destination stop during
  the time window specified.} \item{headway_time_sec}{Actual headway for next
  arriving vehicle during time window specified, in seconds.}
  \item{benchmark_headway_time_sec}{Benchmark headway for each trip, in
  seconds.} \item{threshold_01_flag}{Binary variable for whether a given
  headway was above the first threshold for delayed headways.}
  \item{threshold_02_flag}{Binary variable for whether a given headway was
  above the second threshold for delayed headways.}
  \item{threshold_03_flag}{Binary variable for whether a given headway was
  above the third threshold for delayed headways.}
}
\description{
To get headways and train arrive times for a given station/route/direction in
a certain time window.. Returns a list of headways at an origin station
during a particular time period on a particular route.
}
\examples{
Theadways(from_stop_id = 70007, # Jackson Square Northbound
to_stop_id = 70034, # Malden Southbound
route_id = NULL,
direction_id = 1, # northbound
from_datetime = as.POSIXct("2015-08-03 00:00"),
to_datetime = as.POSIXct("2015-08-03 23:59"),
api_key = "wX9NwuHnZU2ToO7GmGR9uw")
#'

}
