#############################
# Documentation of data files
#############################

#' Barley grain yields in bushels per acre
#'
#' Set of results presented by Duncan (1955), in which Scott-Knott (1974)
#' presented an application of the development of the Scott-Knott test in a
#' randomized block design.
#' References: 1) SCOTT, A. J.; KNOTT, M. A cluster analysis method for grouping
#' means in the analysis of variance. Biometrics, International Biometric
#' Society, v. 30, n. 3, p. 507-512, 1974. 2) DUNCAN, D. B. Multiple range and
#' multiple F Tests. Biometrics, International Biometric Society, v. 11, n. 1,
#' p. 1-42, 1955.
#'
#' @format A list with 4 variables:
#' \describe{
#'   \item{treatment}{Seven varieties of barley conduted by E. Shulkcum of this
#'   Institute at Accomc, Virginia, in 1951}
#'   \item{averages}{Averages of the seven varieties of barley}
#'   \item{mserror}{Result of mean squared error of the analysis
#'   of variance of the experiment}
#'   \item{dferror}{Degrees of freedom of error of the experiment}
#'   \item{replication}{Number of replications of treatments.}
#' }
#'
"ex1ScottKnott"


