% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{MDFS}
\alias{MDFS}
\title{Run end-to-end MDFS}
\usage{
MDFS(data, decision, n.contrast = max(ncol(data)/10, 30), dimensions = 1,
  divisions = NULL, discretizations = 1, range = NULL,
  pseudo.count = 0.25, p.adjust.method = "holm", level = 0.05,
  seed = NULL, use.CUDA = FALSE)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all numeric)}

\item{decision}{decision variable as a boolean vector of length equal to number of observations}

\item{n.contrast}{number of constrast variables (defaults to max of 1/10 of variables number and 30)}

\item{dimensions}{number of dimensions (a positive integer; on CUDA limited to 2--5 range)}

\item{divisions}{number of divisions (from 1 to 15; \code{NULL} selects probable optimal number)}

\item{discretizations}{number of discretizations}

\item{range}{discretization range (from 0.0 to 1.0; \code{NULL} selects probable optimal number)}

\item{pseudo.count}{pseudo count}

\item{p.adjust.method}{method as accepted by \code{\link[stats]{p.adjust}} (\code{"BY"} is recommended for FDR, see Details)}

\item{level}{statistical significance level}

\item{seed}{seed for PRNG used during discretizations (\code{NULL} for random)}

\item{use.CUDA}{whether to use CUDA acceleration (must be compiled with CUDA)}
}
\value{
A \code{\link{list}} with the following fields:
 \itemize{
   \item \code{contrast.indices} -- indices of variables chosen to build contrast variables
   \item \code{contrast.variables} -- built contrast variables
   \item \code{MIG.Result} -- result of ComputeMaxInfoGains
   \item \code{MDFS} -- result of ComputePValue (the MDFS object)
   \item \code{statistic} -- vector of statistic's values (IGs) for corresponding variables
   \item \code{p.value} -- vector of p-values for corresponding variables
   \item \code{adjusted.p.value} -- vector of adjusted p-values for corresponding variables
   \item \code{relevant.variables} -- vector of relevant variables indices
 }
}
\description{
Run end-to-end MDFS
}
\details{
In case of FDR control it is recommended to use Benjamini-Hochberg-Yekutieli p-value adjustment
method (\code{"BY"} in \code{\link[stats]{p.adjust}}) due to unknown dependencies between tests.
}
\examples{
\donttest{
MDFS(madelon$data, madelon$decision, dimensions = 2, divisions = 1,
     range = 0, seed = 0)
}
}
