% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary.R
\name{getBinInfoStates}
\alias{getBinInfoStates}
\title{Info about the states in the binary files of the HMDP model under consideration.}
\usage{
getBinInfoStates(
  prefix = "",
  labels = TRUE,
  stateStr = TRUE,
  fileS = "stateIdx.bin",
  labelS = "stateIdxLbl.bin"
)
}
\arguments{
\item{prefix}{A character string with the prefix added to til binary files.}

\item{labels}{Should labels be extracted.}

\item{stateStr}{Should state strings be extracted. If false then add columns (n0, s0, a0, ...)
where n0 the index of the stage at level 0, s0 the index of the state and a0 the index of the
action. If the HMDP has more than one level columns index (d1, s1, a1, ...) are added.}

\item{fileS}{The binary file containing the description of states.}

\item{labelS}{The binary file containing the state labels.}
}
\value{
A data frame with the information.
}
\description{
Info about the states in the binary files of the HMDP model under consideration.
}
\note{
The model don't have to be loaded, i.e only read the binary files. The state id (\code{sId}) will
not be the same as in the loaded model!
}
