% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.HMDP}
\alias{plot.HMDP}
\title{Plot the state-expanded hypergraph of the MDP.}
\usage{
\method{plot}{HMDP}(x, ...)
}
\arguments{
\item{x}{The MDP model.}

\item{...}{Arguments passed to \code{\link[=plotHypergraph]{plotHypergraph()}}. Moreover, you may use
\itemize{
\item \code{hyperarcColor}: A string. If empty string no colors are used (default). If \code{label} then
use different colors based on the hyperarc/action labels. If \code{policy} then use highlight
the current policy.
\item \code{nodeLabel}: A string. If empty string, then display node labels (default). If \code{sId} then
display the state ids. If \code{sId:label} then display the state ids together with the label.
If \code{sIdx:label} then display the state index and the label. If \code{weight} then display the
node weight.
\item \code{hyperarcShow} A string. If \code{all} then show all hyperarcs (default). If \code{policy} then only
show the current policy.
}}
}
\value{
No return value (NULL invisible), called for side effects (plotting).
}
\description{
Plot the state-expanded hypergraph of the MDP.
}
\examples{
## Set working dir
wd <- setwd(system.file("models", package = "MDP2"))

#### A finite-horizon replacement problem ####
mdp<-loadMDP("machine1_")
plot(mdp)
plot(mdp, hyperarcColor = "label")  # colors based on labels
plot(mdp, hyperarcColor = "label", nodeLabel = "sId:label")  # node labels are 'sId: label'
plot(mdp, nodeLabel = "sIdx:label", radx = 0.02)  # adjust radx in nodes
scrapValues <- c(30, 10, 5, 0)  # scrap values (the values of the 4 states at stage 4)
runValueIte(mdp, "Net reward" , termValues = scrapValues)
plot(mdp, hyperarcColor = "policy")  # highlight optimal policy
plot(mdp, hyperarcShow = "policy", nodeLabel = "weight")  # show only optimal policy


#### An infinite-horizon maintenance problem ####
mdp<-loadMDP("hct611-1_")
plot(mdp)  # plot the first two stages
plot(mdp, hyperarcColor = "label")  # colors based on labels
plot(mdp, hyperarcColor = "label", nodeLabel = "sId:label")  # node labels are 'sId: label'
runPolicyIteAve(mdp,"Net reward","Duration")
plot(mdp, hyperarcColor = "policy")  # highlight optimal policy
plot(mdp, hyperarcShow = "policy")  # show only optimal policy


#### An infinite-horizon hierarchical replacement problem ####
library(magrittr)
mdp<-loadMDP("cow_")
hgf <- getHypergraph(mdp)
# modify labels
dat <- hgf$nodes \%>\% 
   dplyr::mutate(label = dplyr::case_when(
      label == "Low yield" ~ "L",
      label == "Avg yield" ~ "A",
      label == "High yield" ~ "H",
      label == "Dummy" ~ "D",
      label == "Bad genetic level" ~ "Bad",
      label == "Avg genetic level" ~ "Avg",
      label == "Good genetic level" ~ "Good",
      TRUE ~ "Error"
   ))
# assign nodes to grid ids
dat$gId[1:3]<-85:87
dat$gId[43:45]<-1:3
getGId<-function(process,stage,state) {
   if (process==0) start=18
   if (process==1) start=22
   if (process==2) start=26
   return(start + 14 * stage + state)
}
idx<-43
for (process in 0:2)
   for (stage in 0:4)
      for (state in 0:2) {
         if (stage==0 & state>0) break
         idx<-idx-1
         #cat(idx,process,stage,state,getGId(process,stage,state),"\n")
         dat$gId[idx]<-getGId(process,stage,state)
      }
hgf$nodes <- dat
# modify labels
dat <- hgf$hyperarcs \%>\% 
   dplyr::mutate(label = dplyr::case_when(
      label == "Replace" ~ "R",
      label == "Keep" ~ "K",
      label == "Dummy" ~ "D",
      TRUE ~ "Error"
   ),
   col = dplyr::case_when(
      label == "R" ~ "deepskyblue3",
      label == "K" ~ "darkorange1",
      label == "D" ~ "black",
      TRUE ~ "Error"
   ),
   lwd = 0.5,
   label = ""
   ) 
hgf$hyperarcs <- dat
# plot hypergraph
oldpar <- par(mai = c(0, 0, 0, 0))
plotHypergraph(gridDim = c(14, 7), hgf, cex = 0.8, radx = 0.02, rady = 0.03)
par(oldpar)

## Reset working dir
setwd(wd)
}
\seealso{
\code{\link[=getHypergraph]{getHypergraph()}} and \code{\link[=plotHypergraph]{plotHypergraph()}}.
}
