% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ME.fcQR_CLS.R
\name{ME.fcQR_CLS}
\alias{ME.fcQR_CLS}
\title{Bias correction method of applying quantile linear regression to dataset
with one functional covariate with measurement error using corrected loss score method.}
\usage{
ME.fcQR_CLS(
  data.Y,
  data.W,
  data.Z,
  tau = 0.5,
  t_interval = c(0, 1),
  t_points = NULL,
  grid_k,
  grid_h,
  degree = 45,
  observed_X = NULL
)
}
\arguments{
\item{data.Y}{Response variable, can be an atomic vector, a one-column matrix or data frame,
recommended form is a one-column data frame with column name.}

\item{data.W}{A 3-dimensional array, represents \eqn{W}, the measurement of \eqn{X}.
Each row represents a subject.
Each column represent a measurement (time) point.
Each layer represents an observation.}

\item{data.Z}{Scalar covariate(s),
can be not input or NULL (when there's no scalar covariate),
an atomic vector (when only one scalar covariate),
a matrix or data frame, recommended form is a data frame with column name(s).}

\item{tau}{Quantile \eqn{\tau\in(0,1)}, default is 0.5.}

\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate. Default is c(0,1), represent interval \eqn{[0,1]}.}

\item{t_points}{Sequence of the measurement (time) points, default is NULL.}

\item{grid_k}{An atomic vector, of which each element is candidate number of basis.}

\item{grid_h}{A non-zero-value atomic vector, of which each element is candidate value of tunning parameter.}

\item{degree}{Used in computation for derivative and integral, defult is 45, large enough for most scenario.}

\item{observed_X}{For estimating parametric variance. Default is NULL.}
}
\value{
Returns a ME.fcQR_CLS class object. It is a list that contains the following elements.
   \item{estimated_beta_hat}{Estimated coefficients from corrected loss function (including functional part)}
   \item{estimated_beta_t}{Estimated functional curve}
   \item{SE_est}{Estimated parametric variance. Returned only if observed_X is not NULL.}
   \item{estimated_Xbasis}{The basis matrix we used}
   \item{res_naive}{results of naive method}
}
\description{
Zhang et al. proposed a new corrected loss function for a
partially functional linear quantile model with functional measurement error in this manuscript.
They established a corrected quantile objective function of the observed measurement
that is an unbiased estimator of the quantile objective function
that would be obtained if the true measurements were available.
The estimators of the regression parameters are obtained
by optimizing the resulting corrected loss function.
The resulting estimator of the regression parameters is shown to be consistent.
}
\examples{
data(MECfda.data.sim.0.1)
\donttest{
res = ME.fcQR_CLS(data.Y = MECfda.data.sim.0.1$Y,
                data.W = MECfda.data.sim.0.1$W,
               data.Z = MECfda.data.sim.0.1$Z,
               tau = 0.5,
               grid_k = 4:7,
               grid_h = 1:2)
}
}
\references{
Zhang, Mengli, et al.
"PARTIALLY FUNCTIONAL LINEAR QUANTILE REGRESSION WITH MEASUREMENT ERRORS."
Statistica Sinica 33 (2023): 2257-2280.
}
