% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cmd}
\alias{cmd}
\title{Correlation matrix distance}
\usage{
cmd(x, y)
}
\arguments{
\item{x}{First correlation matrix}

\item{y}{Second correlation matrix}
}
\value{
Returns the correlation matrix distance, which is a value between 0 and 1. The correlation matrix distance becomes
zero for equal correlation matrices and unity if they differ to a maximum extent.
}
\description{
Computes the correlation matrix distance between two correlation matrices
}
\examples{

m1 <- matrix(rep(1, 16), 4)
m2 <- matrix(c(1, 0, .5, .5, 0, 1, .5, .5, .5, .5, 1, .5, .5, .5, .5, 1), 4)
m3 <- matrix(c(1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1), 4)
cmd(m1, m1)
cmd(m1, m2)
cmd(m2, m3)

}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\references{
Herdin, M., and Czink, N., and Ozcelik, H., and Bonek, E. (2005). \emph{Correlation matrix distance, a meaningful measure for
evaluation of non-stationary mimo channels}. IEEE VTC.
}
\keyword{univar}

