% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MESS-package.R
\docType{data}
\name{happiness}
\alias{happiness}
\title{Happiness score and tax rates for 148 countries}
\format{A data frame with 148 observations on the following 6 variables.
\describe{ \item{country}{a factor with 148 levels that contain the
country names} \item{happy}{a numeric vector with the average
subject happiness score (on a scale from 0-10)} \item{tax}{a numeric
vector showing the tax revenue as percentage of GDP}
\item{religion}{a factor with levels \code{Buddhist}
\code{Christian} \code{Hindu} \code{Muslim} \code{None} or \code{Other}}
\item{continent}{a factor with levels \code{AF}, \code{AS},
\code{EU}, \code{NA}, \code{OC}, \code{SA}, corresponding to the continents
Africa, Asia, Europe, North America, Ocenaia, South American, respectively}
\item{population}{a numeric vector showing the population (in
millions)} }}
\source{
Data collected by Ellen Ekstroem. \cr Population sizes are from
Wikipedia per August 2nd, 2012
\url{http://en.wikipedia.org/wiki/List_of_countries_by_population} \cr Major
religions are from Wikipedia per August 2nd, 2012
\url{http://en.wikipedia.org/wiki/Religions_by_country} \cr Tax rates are
from Wikipedia per August 2nd, 2012
\url{http://en.wikipedia.org/wiki/List_of_countries_by_tax_revenue_as_percentage_of_GDP}
\cr Average happiness scores are from "Veenhoven, R. Average happiness in
148 nations 2000-2009, World Database of Happiness, Erasmus University
Rotterdam, The Netherlands". Assessed on August 2nd, 2012 at:
\url{http://worlddatabaseofhappiness.eur.nl/hap_nat/findingreports/RankReport_AverageHappiness.php}
}
\description{
Dataset on subjective happiness, tax rates, population sizes, continent, and
major religion for 148 countries
}
\examples{

data(happiness)
with(happiness, symbols(tax, happy, circles=sqrt(population)/8, inches=FALSE, bg=continent))

#
# Make a prettier image with transparent colors
#

newcols <- rgb(t(col2rgb(palette())),
               alpha=100, maxColorValue=255)

with(happiness, symbols(tax, happy, circles=sqrt(population)/8,
                inches=FALSE, bg=newcols[continent],
                xlab="Tax (\% of GDP)", ylab="Happiness"))

#
# Simple analysis
#
res <- lm(happy ~ religion + population + tax:continent, data=happiness)
summary(res)


}
\keyword{datasets}
