% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gaussian.R
\name{MFKnockoffs.create.gaussian}
\alias{MFKnockoffs.create.gaussian}
\title{Sample multivariate Gaussian knockoff variables}
\usage{
MFKnockoffs.create.gaussian(X, mu, Sigma, method = c("asdp", "sdp", "equi"),
  diag_s = NULL)
}
\arguments{
\item{X}{normalized n-by-p realization of the design matrix}

\item{mu}{mean vector of length p for X}

\item{Sigma}{p-by-p covariance matrix for X}

\item{method}{either 'equi', 'sdp' or 'asdp' (default:'asdp')}

\item{diag_s}{pre-computed vector of covariances between the original variables and the knockoffs.
This will be computed according to 'method', if not supplied}
}
\value{
n-by-p matrix of knockoff variables
}
\description{
Samples multivariate Gaussian fixed-design knockoff variables for the original variables.
}
\references{
Candes et al., Panning for Gold: Model-free Knockoffs for High-dimensional Controlled Variable Selection,
  arXiv:1610.02351 (2016).
  \href{https://statweb.stanford.edu/~candes/MF_Knockoffs/index.html}{https://statweb.stanford.edu/~candes/MF_Knockoffs/index.html}
}
\seealso{
Other methods for creating knockoffs: \code{\link{MFKnockoffs.create.approximate_gaussian}},
  \code{\link{MFKnockoffs.create.fixed}}
}
