% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateFTVA.R
\name{calculateFTVA}
\alias{calculateFTVA}
\title{Calculates variable contributions (FTVA)}
\usage{
calculateFTVA(selectedEV, formula = NULL)
}
\arguments{
\item{selectedEV}{The list returned by \code{selectEV}.}

\item{formula}{If null, FTVA is calculated for the selected model in
\code{selectedEV}. Otherwise, a model formula (in the form ~ x + ...)
specifying a model in the trail of forward selection
(\code{selectEV$selection}) for which to calculate FTVA. Response variable
is irrelevant.}
}
\description{
Calculates the Fraction of Total Variation Accounted for (Halvorsen et al.
2015), for the selected model or a chosen model from the results of
\code{\link{selectEV}}.
}
\examples{
\dontrun{
# From vignette:
calculateFTVA(grasslandEVselect, formula("~ prbygall + geoberg + lcucor1 +
tertpi09 + geolmja1"))
}

}
\references{
Halvorsen, R., Mazzoni, S., Bryn, A., & Bakkestuen, V. (2015).
  Opportunities for improved distribution modelling practice via a strict
  maximum likelihood interpretation of MaxEnt. Ecography, 38(2), 172-183.
}
