% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patric.R
\name{pull_PATRIC_genomes}
\alias{pull_PATRIC_genomes}
\title{Automated download of genomes from PATRIC database}
\usage{
pull_PATRIC_genomes(
  output_directory,
  taxonomic_name = NULL,
  database = patric_ftp_path,
  filter = "MIC",
  n_genomes = 0
)
}
\arguments{
\item{output_directory}{local directory to save to}

\item{taxonomic_name}{character of taxonomic bacterial name to download}

\item{database}{local or ftp path to PATRIC database, or loaded database using load_patric_db()}

\item{filter}{"MIC" or "disk" or "all" phenotypes}

\item{n_genomes}{number of genomes (0 = all)}
}
\value{
The number of failed downloads (i.e., 0 if all attempted downloads
were successful).
}
\description{
Automated download of genomes from PATRIC database
}
\examples{
\donttest{
pull_PATRIC_genomes(tempdir(),
                    taxonomic_name = "Escherichia coli",
                    filter = "MIC",
                    n_genomes = 10)
}
}
