% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifier_cop.R
\name{copulaClassifier}
\alias{copulaClassifier}
\title{Train a classification model using copula functions.}
\usage{
copulaClassifier(
  X,
  y,
  distribution = "kernel",
  copula = "frank",
  weights = "likelihood",
  graph_model = "tree",
  k = 7,
  m = 7,
  method_grid = "ml"
)
}
\arguments{
\item{X}{Data frame with \eqn{n} samples and \eqn{d>1} predictor variables.}

\item{y}{a vector of size \eqn{n}, with the classes
to predict.}

\item{distribution}{Marginal distribution to be used: "normal" or "kernel",
by default kernel.}

\item{copula}{Character or vector with the name of the copula to be used:
"frank", "gaussian", "clayton", "joe", "gumbel", "amh","grid", by default "frank".
For parametric copulas, "frank", "gaussian", "clayton", "joe", "gumbel", "amh", one or 
more copulas can be selected. For nonparametric copula, only "grid" can be selected. 
See the examples for more details.
}

\item{weights}{Character with the weight construction method:
"likelihood" or "mutual_information", by default "likelihood".}

\item{graph_model}{Character with the graphical model structure: "tree" or "chain", by default "tree".}

\item{k}{Only for grid copula. Positive integer indicating the
number of subintervals for the \eqn{U2} variable.}

\item{m}{Only for grid copula. Positive integer indicating the number
of subintervals for the \eqn{U1} variable.}

\item{method_grid}{Only for grid copula. Fitting method, least squares "ls" or
maximum likelihood "ml", by default "ml".}
}
\value{
Returns a list with the trained model.
}
\description{
It trains a classification model based on copulas,
the joint density of copulas is built with tree or chain graphic model, as shown in Salinas-Gutiérrez et al., 2014.
}
\examples{
X <- iris[,1:4]
y <- iris$Species
model <- copulaClassifier(X = X, y = y, copula = "frank",
                      distribution = "kernel", graph_model = "tree")
y_pred <- copulaPredict(X = X, model = model)
table(y,y_pred$class)
#Example 2
X <- iris[,1:4]
y <- iris$Species
model <- copulaClassifier(X = X, y = y, copula = c("frank","clayton"), 
                        distribution = "kernel", graph_model = "chain")
y_pred <- copulaPredict(X = X, model = model)
table(y,y_pred$class)
}
\references{
{
Salinas-Gutiérrez, R., Hernández-Aguirre, A., Villa-Diharce, E.R. (2014). Copula selection
for graphical models in continuous Estimation of Distribution Algorithms. \emph{Computational
Statistics}, \bold{29}(3–4):685–713. \doi{10.1007/s00180-013-0457-y}
}
}
