% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlapgglasso}
\alias{overlapgglasso}
\title{Group-lasso with overlapping groups}
\source{
Laurent Jacob, Guillaume Obozinski, and Jean-Philippe Vert. 2009. Group lasso with overlap and graph lasso. 
In Proceedings of the 26th Annual International Conference on Machine Learning (ICML '09).
}
\usage{
overlapgglasso(
  X,
  y,
  var,
  group,
  lambda = NULL,
  weight = NULL,
  loss = c("ls", "logit"),
  intercept = TRUE,
  ...
)
}
\arguments{
\item{X}{matrix of size n*p}

\item{y}{vector of size n. If loss = "logit", elements of y must be in {-1,1}}

\item{var}{vector containing the variable to use}

\item{group}{vector containing the associated groups}

\item{lambda}{lambda values for group lasso. If not provided, the function generates its own values of lambda}

\item{weight}{a vector the weight for each group. Default is the square root of the size of each group}

\item{loss}{a character string specifying the loss function to use, valid options are: "ls" least squares loss 
(regression) and "logit" logistic loss (classification)}

\item{intercept}{should an intercept be included in the model ?}

\item{...}{Others parameters for \code{\link{gglasso}} function}
}
\value{
a MLGL object containing:
\describe{
  \item{lambda}{lambda values}
  \item{b0}{intercept values for \code{lambda}}
  \item{beta}{A list containing the values of estimated coefficients for each values of \code{lambda}}
  \item{var}{A list containing the index of selected variables for each values of \code{lambda}}
  \item{group}{A list containing the values index of selected groups for each values of \code{lambda}}
  \item{nVar}{A vector containing the number of non zero coefficients for each values of \code{lambda}}
  \item{nGroup}{A vector containing the number of non zero groups for each values of \code{lambda}}
  \item{structure}{A list containing 3 vectors. var: all variables used. group: associated groups.
  weight: weight associated with the different groups.}
  \item{time}{computation time}
  \item{dim}{dimension of \code{X}}
}
}
\description{
Group-lasso with overlapping groups
}
\details{
Use a group-lasso algorithm (see \code{\link{gglasso}}) to solve a group-lasso with overlapping groups.
Each variable j of the original matrix \code{X} is paste k(j) times in a new dataset with k(j) the number of 
different groups containing the variable j.
The new dataset is used to solve the group-lasso with overlapping groups running a group-lasso algorithm.
}
\examples{
# Least square loss
set.seed(42)
X <- simuBlockGaussian(50, 12, 5, 0.7)
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
var <- c(1:60, 1:8, 7:15)
group <- c(rep(1:12, each = 5), rep(13, 8), rep(14, 9))
res <- overlapgglasso(X, y, var, group)

# Logistic loss
y <- 2 * (rowSums(X[, 1:4]) > 0) - 1
var <- c(1:60, 1:8, 7:15)
group <- c(rep(1:12, each = 5), rep(13, 8), rep(14, 9))
res <- overlapgglasso(X, y, var, group, loss = "logit")
}
\seealso{
\code{\link{listToMatrix}}
}
